package boot;

import org.pgusb.usbDllAdapter.ReadBytes;
import org.pgusb.usbDllAdapter.UsbDllAdapter;
import org.pgusb.usbDllAdapter.WriteBytes;

public class BootLoader {

	static final int MP_WRITE=0;
	static final int MP_READ=1;
	static final int INVALID_HANDLE_VALUE=-1;
	static final String vid_pid= "vid_04d8&pid_000b";
	private int selection;
	private int myOutPipe=-1;
	private int myInPipe=-1;
	
	
	
	public void init(int sel){
		selection = sel;
	}
	
	public ReadBytes SendReceivePacket(int myOutPipe, int myInPipe,byte[] SendData, int SendLength,
			int ReceiveLength,int SendDelay, int ReceiveDelay) {
		
		int ExpectedReceiveLength = ReceiveLength; 
		
		if(myOutPipe != INVALID_HANDLE_VALUE && myInPipe != INVALID_HANDLE_VALUE){
			try {
				WriteBytes wb = UsbDllAdapter.MPUSBWrite(myOutPipe,SendData,SendLength,SendDelay);
				//System.out.println("Quiero write: " + SendLength + " Writed Bytes : "+ wb.getLength()+ " retval: "+ wb.getRetVal());
				if (wb.getRetVal()!=0) {
					ReadBytes rb = UsbDllAdapter.MPUSBRead(myInPipe, ExpectedReceiveLength,ReceiveDelay);
					//System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
					if(rb.getRetVal()!=0) {
				        if(rb.getLength() == ExpectedReceiveLength){
				            return new ReadBytes(rb.getReadBytes(),rb.getLength(),1);   // Success!
				        }
				        else if(rb.getLength() < ExpectedReceiveLength)
				        {
				            return new ReadBytes(rb.getReadBytes(),rb.getLength(),2);   // Partially failed, incorrect receive length
				        }//end if else
				    }
				}
			}//end if
			catch (Exception e){
				System.out.println("Excepcion en SendReceivePacket");
			}
		}
		return new ReadBytes(null,0,-1);  // Operation Failed
	}//end SendReceivePacket

	
	public boolean open(){
		String out_pipe= "\\MCHP_EP1";
		String in_pipe= "\\MCHP_EP1";
		try {
			myOutPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_WRITE,0);
			myInPipe = UsbDllAdapter.MPUSBOpen(selection,vid_pid,out_pipe,MP_READ,0);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		if(myOutPipe == INVALID_HANDLE_VALUE || myInPipe == INVALID_HANDLE_VALUE)
	    {
	        System.out.println("Failed to open data pipes.\r\n");
	        return false;
	    }//end if

		System.out.println("myOutPipe: "+ myOutPipe + " myInPipe:" + myInPipe);
		return true;
	}
	public boolean close(){
	    try {
			
		    UsbDllAdapter.MPUSBClose(myOutPipe);
		    UsbDllAdapter.MPUSBClose(myInPipe);
		    }
		    catch (Exception e){
		    	System.out.println("error a hacer el close");
		    	System.out.println(e.getMessage());
		    	return false;
		    }
		    myOutPipe = myInPipe = INVALID_HANDLE_VALUE;
		return true;
	}
	
	public byte[] readFlash(int address,int len) {
		BootDataPacket resp = new BootDataPacket();
	    BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_FLASH,address,len,null);
		System.out.print("packet enviado: ");
	    printBinData(bdp.getCommand());
		int RecvLength=len+BootDataPacket.OVER_HEAD;
	    //System.out.println(send_buf.toString());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,bdp.getCommand(),bdp.getCommand().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	//System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			resp.parse(rb.getReadBytes());
			System.out.print("packet recibido: ");
		    resp.printBinData();
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return resp.getData();
	}
	
	public byte[] getVersion() {
		int len = 4;
		BootDataPacket resp = new BootDataPacket();
	    BootDataPacket bdp = new BootDataPacket(BootDataPacket.READ_VERSION,0,len,null);
		System.out.print("packet enviado: ");
	    bdp.printBinData();
		int RecvLength=4;
	    //System.out.println(send_buf.toString());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,bdp.getPacket(),bdp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			resp.parse(rb.getReadBytes());
			System.out.print("packet recibido: ");
			resp.printBinData();
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return null;
	}
	public boolean writeFlash(int address,byte[] data) {
		boolean resp=false;
		if (data!=null && data.length<=16){
			int len=data.length;
	    	BootDataPacket bdp = new BootDataPacket(BootDataPacket.WRITE_FLASH,address,len,data);
			bdp.printBinData();
			int RecvLength=1;
		    //System.out.println(send_buf.toString());
		    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,bdp.getPacket(),bdp.getPacket().length,RecvLength,1000,1000);
		    if(rb.getRetVal() == 1)
		    {
		    	//System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
				if (rb.getReadBytes()[0]==BootDataPacket.WRITE_FLASH){
					resp = true;
				}
		    }
		    else {
		        System.out.println("USB Operation Failed\r\n");
		    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
		    }
	    }
		return resp;
	}
	public boolean eraseFlash(int address) {
		boolean resp=false;
		BootDataPacket bdp = new BootDataPacket(BootDataPacket.ERASE_FLASH,address,5,null);
		bdp.printBinData();
		int RecvLength=1;
	    //System.out.println(send_buf.toString());
	    ReadBytes rb =SendReceivePacket(myOutPipe,myInPipe,bdp.getPacket(),bdp.getPacket().length,RecvLength,1000,1000);
	    if(rb.getRetVal() == 1)
	    {
	    	System.out.println("Read Bytes : "+ rb.getLength()+ " retval: "+ rb.getRetVal());
			if (rb.getReadBytes()[0]==BootDataPacket.ERASE_FLASH){
				resp = true;
			}
	    }
	    else {
	        System.out.println("USB Operation Failed\r\n");
	    	System.out.println("return: " + rb.getReadBytes() + " length:" + rb.getLength() + " ret:" +rb.getRetVal() );
	    }
	    return resp;
	}
	
	public void printBinData(byte[] c){
		
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
}
